/*
 * Decompiled with CFR 0.152.
 */
package sajt.shdzfp.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class GZipUtils {
    public static final int BUFFER = 1024;
    public static final String EXT = ".gz";
    private static final Logger log = Logger.getLogger(GZipUtils.class);

    public static byte[] compress(byte[] data) throws Exception {
        byte[] output = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZipUtils.compress(bais, baos);
        output = baos.toByteArray();
        baos.flush();
        baos.close();
        bais.close();
        return output;
    }

    public static void compress(File file) throws Exception {
        GZipUtils.compress(file, true);
    }

    public static void compress(File file, boolean delete) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        FileOutputStream fos = new FileOutputStream(String.valueOf(file.getPath()) + EXT);
        GZipUtils.compress(fis, fos);
        fis.close();
        fos.flush();
        fos.close();
        if (delete) {
            boolean fal = file.delete();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u6587\u4ef6\u5220\u9664" + fal));
            }
        }
    }

    public static void compress(InputStream is, OutputStream os) throws Exception {
        int count;
        GZIPOutputStream gos = new GZIPOutputStream(os);
        byte[] data = new byte[1024];
        while ((count = is.read(data, 0, 1024)) != -1) {
            gos.write(data, 0, count);
        }
        gos.finish();
        gos.flush();
        gos.close();
    }

    public static void compress(String path) throws Exception {
        GZipUtils.compress(path, true);
    }

    public static void compress(String path, boolean delete) throws Exception {
        File file = new File(path);
        GZipUtils.compress(file, delete);
    }

    public static byte[] decompress(byte[] data) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZipUtils.decompress(bais, baos);
        data = baos.toByteArray();
        baos.flush();
        baos.close();
        bais.close();
        return data;
    }

    public static void decompress(InputStream is, OutputStream os) throws Exception {
        int count;
        GZIPInputStream gis = new GZIPInputStream(is);
        byte[] data = new byte[1024];
        while ((count = gis.read(data, 0, 1024)) != -1) {
            os.write(data, 0, count);
        }
        gis.close();
    }
}

