/*
 * Decompiled with CFR 0.152.
 */
package sajt.shdzfp.kp;

import com.aisino.ca.CaApi;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.InputSource;
import sajt.shdzfp.bean.CaMsg;
import sajt.shdzfp.bean.Data;
import sajt.shdzfp.bean.GlobalInfo;
import sajt.shdzfp.bean.ReturnStateInfo;
import sajt.shdzfp.util.GZipUtils;
import sajt.shdzfp.util.TripleDESUtil;
import sajt.shdzfp.util.ValidateUtil;
import sajt.shdzfp.util.XMLShellFactory;
import sajt.shdzfp.util.XmlPar;
import sun.misc.BASE64Encoder;

public class ProXmlPT {
    public static String CHARSET = "UTF-8";
    private static final Logger log = Logger.getLogger(ProXmlPT.class);

    public static String encode(String res) throws Exception {
        Base64 base = new Base64();
        return new String(base.encode(res.getBytes(CHARSET)));
    }

    public static byte[] encode(byte[] res) throws Exception {
        Base64 base = new Base64();
        return base.encode(res);
    }

    public static String decode(String str) throws UnsupportedEncodingException, DecoderException {
        return new String(new Base64().decode(str.getBytes()), CHARSET);
    }

    public static byte[] decodeByte(byte[] str) throws DecoderException {
        return new Base64().decode(str);
    }

    public static byte[] decode(byte[] str) throws UnsupportedEncodingException, DecoderException {
        return new Base64().decode(str);
    }

    public static String isZip(String xml, int size) {
        if (xml == null) {
            xml = "";
        }
        String isz = "0";
        if (xml.getBytes().length > 1024 * size) {
            isz = "1";
        }
        return isz;
    }

    public static String getXml(GlobalInfo globalInfo, ReturnStateInfo returnStateInfo, Data data, CaMsg msg, String key) throws Exception {
        return ProXmlPT.getXml(globalInfo, returnStateInfo, data, true, msg, key);
    }

    private static String getXml(GlobalInfo globalInfo, ReturnStateInfo returnStateInfo, Data data, boolean flag, CaMsg msg, String key) throws Exception {
        String resData = "";
        Element root = new Element(XmlPar.ROOT_BASE);
        Namespace ns = Namespace.getNamespace((String)XmlPar.NS_ONE);
        root.addNamespaceDeclaration(ns);
        Namespace ns1 = Namespace.getNamespace((String)"xsi", (String)XmlPar.NS_TWO);
        root.addNamespaceDeclaration(ns1);
        Namespace ns2 = Namespace.getNamespace((String)"schemaLocation", (String)XmlPar.NS_THREE);
        root.addNamespaceDeclaration(ns2);
        Document doc = new Document(root);
        Element eRoot = doc.getRootElement();
        eRoot.setAttribute("version", XmlPar.VERSION_NO);
        Element eGlobalInfo = new Element(XmlPar.GLOBALINFO);
        Element eterminalCode = new Element(XmlPar.TERMINALCODE);
        eterminalCode.setText(globalInfo.getTerminalCode());
        eGlobalInfo.addContent((Content)eterminalCode);
        Element eAppID = new Element(XmlPar.APPID);
        eAppID.setText(globalInfo.getAppId());
        eGlobalInfo.addContent((Content)eAppID);
        Element eversion = new Element(XmlPar.VERSION);
        eversion.setText(globalInfo.getVersion());
        eGlobalInfo.addContent((Content)eversion);
        Element eInterfaceCode = new Element(XmlPar.INTERFACECODE);
        eInterfaceCode.setText(globalInfo.getInterfaceCode());
        eGlobalInfo.addContent((Content)eInterfaceCode);
        Element ERequestCode = new Element(XmlPar.REQUESTCODE);
        ERequestCode.setText(globalInfo.getRequestCode());
        eGlobalInfo.addContent((Content)ERequestCode);
        Element eRequestTime = new Element(XmlPar.REQUESTTIME);
        eRequestTime.setText(globalInfo.getRequestTime());
        eGlobalInfo.addContent((Content)eRequestTime);
        Element eResponseCode = new Element(XmlPar.RESPONSECODE);
        eResponseCode.setText(globalInfo.getResponseCode());
        eGlobalInfo.addContent((Content)eResponseCode);
        Element eDataExchangeId = new Element(XmlPar.DATAEXCHANGEID);
        eDataExchangeId.setText(globalInfo.getDataExchangeId());
        eGlobalInfo.addContent((Content)eDataExchangeId);
        Element eUserName = new Element(XmlPar.USERNAME);
        eUserName.setText(globalInfo.getUserName());
        eGlobalInfo.addContent((Content)eUserName);
        Element ePassWord = new Element(XmlPar.PASSWORD);
        ePassWord.setText(globalInfo.getPassWord());
        eGlobalInfo.addContent((Content)ePassWord);
        Element etaxpayerId = new Element(XmlPar.TAXPAYERID);
        etaxpayerId.setText(globalInfo.getTaxpayerId());
        eGlobalInfo.addContent((Content)etaxpayerId);
        Element eauthorizationCode = new Element(XmlPar.AUTHORIZATIONCODE);
        eauthorizationCode.setText(globalInfo.getAuthorizationCode());
        eGlobalInfo.addContent((Content)eauthorizationCode);
        Element eReturnStateInfo = new Element(XmlPar.RETURNSTATEINFO);
        Element eReturnCode = new Element(XmlPar.RETURNCODE);
        eReturnCode.setText(returnStateInfo.getReturnCode());
        eReturnStateInfo.addContent((Content)eReturnCode);
        Element eReturnMessage = new Element(XmlPar.RETURNMESSAGE);
        if (returnStateInfo.getReturnMessage() != null && !returnStateInfo.getReturnMessage().equals("null") && !returnStateInfo.getReturnMessage().equals("")) {
            eReturnMessage.setText(ProXmlPT.encode(returnStateInfo.getReturnMessage()));
        } else {
            eReturnMessage.setText("");
        }
        eReturnStateInfo.addContent((Content)eReturnMessage);
        Element eData = new Element(XmlPar.DATA);
        Element eDataDescription = new Element(XmlPar.DATADESCRIPTION);
        Element eZipCode = new Element(XmlPar.ZIPCODE);
        String iszip = "";
        iszip = data != null && data.getZipCode() != null ? data.getZipCode() : ProXmlPT.isZip(data.getContent(), 10);
        eZipCode.setText(iszip);
        eDataDescription.addContent((Content)eZipCode);
        Element eEncryptCode = new Element(XmlPar.ENCRYPTCODE);
        eEncryptCode.setText(data.getEncryptCode());
        eDataDescription.addContent((Content)eEncryptCode);
        Element eCodeType = new Element(XmlPar.CODETYPE);
        eCodeType.setText(data.getCodeType());
        eDataDescription.addContent((Content)eCodeType);
        Element eContent = new Element(XmlPar.CONTENT);
        String content = "";
        if (flag) {
            content = ProXmlPT.encodeData(data.getContent(), iszip, data.getEncryptCode(), key, globalInfo.getUserName(), globalInfo.getTaxpayerId(), msg);
            eContent.setText(content);
        } else {
            eContent.setText(data.getData());
        }
        eData.addContent((Content)eDataDescription);
        eData.addContent((Content)eContent);
        root.addContent((Content)eGlobalInfo);
        root.addContent((Content)eReturnStateInfo);
        root.addContent((Content)eData);
        ByteArrayOutputStream byteRsp = null;
        Format format = Format.getCompactFormat();
        format.setEncoding(CHARSET);
        format.setIndent(" ");
        XMLOutputter xmlout = new XMLOutputter(format);
        byteRsp = new ByteArrayOutputStream();
        xmlout.output(doc, (OutputStream)byteRsp);
        resData = byteRsp.toString(CHARSET);
        if (!ValidateUtil.checkParmaterIsEmpty(content)) {
            int conbg = resData.indexOf("<content>") + 9;
            int conend = resData.indexOf("</content>");
            String con = resData.substring(conbg, conend);
            resData = resData.replace(con, ProXmlPT.replaceBlank(content));
        }
        return resData;
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static Map<String, Object> getInterface(String requestMessage) throws Exception {
        return ProXmlPT.getInterface(requestMessage, true);
    }

    public static Map<String, Object> getInterfaceOuter(String requestMessage) throws Exception {
        return ProXmlPT.getInterface(requestMessage, false);
    }

    public static Map<String, Object> getInterface(String requestMessage, boolean flag) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        GlobalInfo globalInfo = new GlobalInfo();
        SAXBuilder sb = new SAXBuilder();
        StringReader read = new StringReader(requestMessage);
        InputSource source = new InputSource(read);
        Document doc = sb.build(source);
        Element root = doc.getRootElement();
        List node = root.getChildren();
        if (node != null && node.size() > 0) {
            int i = 0;
            while (i < node.size()) {
                Element e1 = (Element)node.get(i);
                if (e1.getName().equals(XmlPar.GLOBALINFO)) {
                    globalInfo.setTerminalCode(e1.getChild(XmlPar.TERMINALCODE).getText() == null ? "" : e1.getChild(XmlPar.TERMINALCODE).getText());
                    globalInfo.setAppId(e1.getChild(XmlPar.APPID).getText() == null ? "" : e1.getChild(XmlPar.APPID).getText());
                    globalInfo.setVersion(e1.getChild(XmlPar.VERSION).getText() == null ? "" : e1.getChild(XmlPar.VERSION).getText());
                    globalInfo.setInterfaceCode(e1.getChild(XmlPar.INTERFACECODE).getText() == null ? "" : e1.getChild(XmlPar.INTERFACECODE).getText());
                    globalInfo.setUserName(e1.getChild(XmlPar.USERNAME).getText() == null ? "" : e1.getChild(XmlPar.USERNAME).getText());
                    globalInfo.setPassWord(e1.getChild(XmlPar.PASSWORD).getText() == null ? "" : e1.getChild(XmlPar.PASSWORD).getText());
                    globalInfo.setTaxpayerId(e1.getChild(XmlPar.TAXPAYERID).getText() == null ? "" : e1.getChild(XmlPar.TAXPAYERID).getText());
                    globalInfo.setAuthorizationCode(e1.getChild(XmlPar.AUTHORIZATIONCODE).getText() == null ? "" : e1.getChild(XmlPar.AUTHORIZATIONCODE).getText());
                    globalInfo.setRequestCode(e1.getChild(XmlPar.REQUESTCODE).getText() == null ? "" : e1.getChild(XmlPar.REQUESTCODE).getText());
                    globalInfo.setRequestTime(e1.getChild(XmlPar.REQUESTTIME).getText() == null ? "" : e1.getChild(XmlPar.REQUESTTIME).getText());
                    globalInfo.setResponseCode(e1.getChild(XmlPar.RESPONSECODE).getText() == null ? "" : e1.getChild(XmlPar.RESPONSECODE).getText());
                    globalInfo.setDataExchangeId(e1.getChild(XmlPar.DATAEXCHANGEID).getText() == null ? "" : e1.getChild(XmlPar.DATAEXCHANGEID).getText());
                    map.put(e1.getName(), globalInfo);
                }
                if (e1.getName().equals(XmlPar.RETURNSTATEINFO)) {
                    ReturnStateInfo returneStateInfo = new ReturnStateInfo();
                    returneStateInfo.setReturnCode(e1.getChild(XmlPar.RETURNCODE).getText() == null ? "" : e1.getChild(XmlPar.RETURNCODE).getText());
                    if (e1.getChild(XmlPar.RETURNMESSAGE).getText() != null && !e1.getChild(XmlPar.RETURNMESSAGE).getText().equals("")) {
                        returneStateInfo.setReturnMessage(ProXmlPT.decode(e1.getChild(XmlPar.RETURNMESSAGE).getText()) == null ? "" : e1.getChild(XmlPar.RETURNMESSAGE).getText());
                    } else {
                        returneStateInfo.setReturnMessage("");
                    }
                    map.put(e1.getName(), returneStateInfo);
                }
                if (e1.getName().equals(XmlPar.DATA)) {
                    Data data = new Data();
                    data.setDataDescription(e1.getChild(XmlPar.DATADESCRIPTION).getText() == null ? "" : e1.getChild(XmlPar.DATADESCRIPTION).getText());
                    data.setZipCode(e1.getChild(XmlPar.DATADESCRIPTION).getChild(XmlPar.ZIPCODE).getText() == null ? "" : e1.getChild(XmlPar.DATADESCRIPTION).getChild(XmlPar.ZIPCODE).getText());
                    data.setEncryptCode(e1.getChild(XmlPar.DATADESCRIPTION).getChild(XmlPar.ENCRYPTCODE).getText() == null ? "" : e1.getChild(XmlPar.DATADESCRIPTION).getChild(XmlPar.ENCRYPTCODE).getText());
                    data.setCodeType(e1.getChild(XmlPar.DATADESCRIPTION).getChild(XmlPar.CODETYPE).getText() == null ? "" : e1.getChild(XmlPar.DATADESCRIPTION).getChild(XmlPar.CODETYPE).getText());
                    log.debug((Object)e1.getChild(XmlPar.CONTENT).getText());
                    map.put(XmlPar.ENCRYPTIONCON, e1.getChild(XmlPar.CONTENT).getText());
                    data.setContent(e1.getChild(XmlPar.CONTENT).getText());
                    map.put(e1.getName(), data);
                }
                ++i;
            }
        }
        return map;
    }

    public static String getDsptbm(String requestMessage) throws Exception {
        SAXBuilder sb = new SAXBuilder();
        StringReader read = new StringReader(requestMessage);
        InputSource source = new InputSource(read);
        Document doc = sb.build(source);
        Element root = doc.getRootElement();
        List node = root.getChildren();
        if (node != null && node.size() > 0) {
            int i = 0;
            while (i < node.size()) {
                Element e1 = (Element)node.get(i);
                if (e1.getName().equals(XmlPar.GLOBALINFO)) {
                    return e1.getChild(XmlPar.USERNAME).getText() == null ? "" : e1.getChild(XmlPar.USERNAME).getText().trim();
                }
                ++i;
            }
        }
        return "";
    }

    public static String getCurDate(String formatStyle) {
        SimpleDateFormat format1 = new SimpleDateFormat(formatStyle);
        return format1.format(new Date());
    }

    public static String getFormatDate(Date date, String formatStyle) {
        SimpleDateFormat format1 = new SimpleDateFormat(formatStyle);
        return format1.format(date);
    }

    public static String decodeData(String org, String zipCode, String encryptCode, String password, String dsptbm, String nsrsbh) throws Exception {
        if (org != null && !org.equals("")) {
            byte[] temp_content = org.getBytes(CHARSET);
            temp_content = ProXmlPT.decode(temp_content);
            if ("1".equals(zipCode)) {
                temp_content = GZipUtils.decompress(temp_content);
            }
            if (!("1".equals(encryptCode) || "2".equals(encryptCode) || "0".equals(encryptCode))) {
                throw new Exception("\u5185\u5c42\u62a5\u6587\u7684\u52a0\u5bc6\u65b9\u5f0f\u4e0d\u5bf9\u3002");
            }
            String content = new String(temp_content, CHARSET);
            return content;
        }
        return "";
    }

    public static String encodeData(String org, String zipCode, String encryptCode, String key, String dsptbm, String taxcode, CaMsg msg) throws Exception {
        byte[] temp_content;
        byte[] byArray = temp_content = org == null ? "".getBytes() : org.getBytes(CHARSET);
        if (StringUtils.isNotEmpty((String)org)) {
            if ("1".equals(encryptCode)) {
                if (StringUtils.isEmpty((String)key)) {
                    throw new Exception("\u52a0\u5bc6\u65b9\u5f0f\u4e3a3DES\uff0c\u52a0\u5bc6\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
                }
                temp_content = TripleDESUtil.encryptMode(key, temp_content);
            } else if ("2".equals(encryptCode)) {
                if (msg == null) {
                    throw new Exception("\u52a0\u5bc6\u65b9\u5f0f\u4e3aCA\uff0cCA\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
                }
                temp_content = CaApi.encrypt7sign(FileUtils.readFileToString((File)new File(msg.getPLATFORM_DECRYPTCER())), FileUtils.readFileToByteArray((File)new File(msg.getCLIENT_DECRYPTPFX())), msg.getCLIENT_DECRYPTPFX_KEY(), org);
            } else {
                throw new Exception("\u52a0\u5bc6\u65b9\u5f0f\u6709\u8bef");
            }
            if ("1".equals(zipCode)) {
                temp_content = GZipUtils.compress(temp_content);
            }
            String content = new BASE64Encoder().encode(temp_content);
            return content;
        }
        return "";
    }

    public static ReturnStateInfo getReturnStateInfo(String returnStateCode, String returnMessage) {
        ReturnStateInfo returnStateInfo = new ReturnStateInfo();
        returnStateInfo.setReturnCode(returnStateCode);
        returnStateInfo.setReturnMessage(returnMessage);
        return returnStateInfo;
    }

    public static Data getData(ByteArrayOutputStream out) throws Exception {
        Data data = new Data();
        data.setEncryptCode("");
        data.setCodeType("");
        String temp_str = new String(out.toByteArray(), CHARSET);
        data.setZipCode(ProXmlPT.isZip(temp_str, 10));
        temp_str = temp_str != null && !temp_str.equals("null") && !temp_str.equals("") ? temp_str.substring(temp_str.indexOf("<ROOT>") + 6, temp_str.lastIndexOf("</ROOT>")) : "";
        data.setContent(temp_str);
        return data;
    }

    public static String replaceStr(String s) {
        return s.replaceAll(" ", "");
    }

    public static List<?> getDataRoot(String xml) throws Exception {
        String xmlRootStart = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>  <ROOT>";
        String xmlRootEnd = "</ROOT>";
        if (xml.startsWith("<?xml")) {
            XMLShellFactory factory = XMLShellFactory.newInstance();
            return (List)factory.generateDomainObject(xml).get(0);
        }
        XMLShellFactory factory = XMLShellFactory.newInstance();
        return (List)factory.generateDomainObject(String.valueOf(xmlRootStart) + xml + xmlRootEnd).get(0);
    }

    public static GlobalInfo getGlobalInfo(String busiType, String dsptbm, Date requestTime) {
        GlobalInfo globalInfo = new GlobalInfo();
        globalInfo.setAppId(XmlPar.WLFP);
        globalInfo.setInterfaceCode(busiType);
        globalInfo.setRequestTime(ProXmlPT.getCurDate("yyyyMMddHHmmss"));
        globalInfo.setResponseCode("121");
        globalInfo.setRequestCode(dsptbm);
        globalInfo.setUserName(dsptbm);
        return globalInfo;
    }

    public static GlobalInfo getGlobalInfo(String busiType, String dsptbm, String dataExId) {
        GlobalInfo globalInfo = new GlobalInfo();
        globalInfo.setAppId(XmlPar.WLFP);
        globalInfo.setInterfaceCode(busiType);
        globalInfo.setRequestTime(ProXmlPT.getCurDate("yyyyMMddHHmmss"));
        globalInfo.setResponseCode("121");
        globalInfo.setRequestCode(dsptbm);
        globalInfo.setUserName(dsptbm);
        globalInfo.setDataExchangeId(dataExId);
        return globalInfo;
    }

    public static GlobalInfo getnewGlobalInfo(String dsptbm) {
        GlobalInfo globalInfo = new GlobalInfo();
        globalInfo.setUserName(dsptbm);
        globalInfo.setAppId(XmlPar.WLFP);
        globalInfo.setRequestTime(ProXmlPT.getCurDate("yyyyMMddHHmmss"));
        globalInfo.setResponseCode("121");
        return globalInfo;
    }

    public static String getRdom(int ws) {
        Random r = new Random();
        String nums = Integer.toString(Math.abs(r.nextInt(Integer.MAX_VALUE)));
        if (nums.length() >= ws) {
            return nums.substring(nums.length() - ws);
        }
        return StringUtils.leftPad((String)nums, (int)ws, (String)"0");
    }

    public static String beanToxml(Object obj) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLShellFactory.newInstance().saveXml(out, obj);
        Data data = ProXmlPT.getData(out);
        return data.getContent();
    }
}

