/*
 * Decompiled with CFR 0.152.
 */
package sajt.shdzfp.util;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import sajt.shdzfp.util.XMLShellImp;

public class XMLShellFactory {
    public static String xmlCharset = "UTF-8";
    public static String rootElementName = "ROOT";
    private static final Log log = LogFactory.getLog(XMLShellFactory.class);
    private static XMLShellFactory factory;

    private XMLShellFactory() {
    }

    public static XMLShellFactory newInstance() {
        if (factory == null) {
            factory = new XMLShellFactory();
        }
        return factory;
    }

    public List generateDomainObject(String xml) throws Exception {
        XMLShellImp xmlShell = new XMLShellImp();
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(xmlCharset));
        List list = xmlShell.parseXML(is);
        return list;
    }

    public boolean saveXml(OutputStream out, Object obj) {
        XMLShellImp xmlShell = new XMLShellImp(rootElementName);
        Document document = null;
        log.info((Object)"--begin save xml to out--");
        if (obj == null) {
            log.error((Object)"null obj param");
            return false;
        }
        try {
            document = xmlShell.genXMLRootEle(null);
            if (obj.getClass().isAssignableFrom(List.class) || obj.getClass().isAssignableFrom(ArrayList.class)) {
                Iterator it = ((List)obj).iterator();
                while (it.hasNext()) {
                    xmlShell.recurInsertEle(document.getRootElement(), it.next());
                }
            } else {
                xmlShell.recurInsertEle(document.getRootElement(), obj);
            }
            xmlShell.saveXML(document, out, xmlCharset);
            log.info((Object)"--finish save xml--\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    public String getXml(Object object) throws Exception {
        if (object == null) {
            return "";
        }
        XMLShellImp xmlShell = new XMLShellImp(rootElementName);
        Document document = xmlShell.genXMLRootEle(null);
        if (object.getClass().isAssignableFrom(List.class) || object.getClass().isAssignableFrom(ArrayList.class)) {
            Iterator it = ((List)object).iterator();
            while (it.hasNext()) {
                xmlShell.recurInsertEle(document.getRootElement(), it.next());
            }
        } else {
            xmlShell.recurInsertEle(document.getRootElement(), object);
        }
        return document.asXML();
    }
}

