/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.executor;

import com.kingbase8.Driver;
import com.kingbase8.core.BaseConnection;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.dispatcher.executor.AbstractExecuteCommand;
import com.kingbase8.dispatcher.executor.DispatchAbstractStatement;
import com.kingbase8.dispatcher.executor.command.StatmentCommand;
import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.jdbc.KbStatement;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class DispatchStatementV2
extends DispatchAbstractStatement
implements Statement {
    protected boolean isClosed = false;
    private boolean closeOnCompletion = false;

    public DispatchStatementV2(DispatchConnection con) {
        this.dispatchConnection = con;
        this.createCommand = new StatmentCommand();
    }

    public DispatchStatementV2(DispatchConnection con, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.dispatchConnection = con;
        this.createCommand = new StatmentCommand(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public DispatchStatementV2(DispatchConnection con, int resultSetType, int resultSetConcurrency) {
        this.dispatchConnection = con;
        this.createCommand = new StatmentCommand(resultSetType, resultSetConcurrency);
    }

    @Override
    public ResultSet executeQuery(final String sql) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeQuery(" + sql + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public ResultSet execute(Statement t) throws SQLException {
                KbResultSet brs;
                BaseConnection conn = (BaseConnection)t.getConnection();
                ResultSet rs = t.executeQuery(sql);
                if (conn.isSlave() && conn.isZeroResend() && (brs = (KbResultSet)rs).getTupleCount() == 0) {
                    rs.close();
                    throw new KSQLException("resultSet size is 0 ,try to switch to main", KSQLState.NO_DATA);
                }
                return rs;
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public int executeUpdate(final String sql) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(sql);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public void close() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.close()";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                t.close();
                return null;
            }
        };
        this.executeTemplet(ec, 3);
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getMaxFieldSize()";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getMaxFieldSize();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public void setMaxFieldSize(final int max) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setMaxFieldSize(" + max + ")";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setMaxFieldSize(max);
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public int getMaxRows() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getMaxRows();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public void setMaxRows(final int max) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setMaxRows(max);
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public void setEscapeProcessing(final boolean enable) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setEscapeProcessing(enable);
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getQueryTimeout();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public void setQueryTimeout(final int seconds) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setQueryTimeout(seconds);
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public void cancel() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.cancel();
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        AbstractExecuteCommand<SQLWarning> ec = new AbstractExecuteCommand<SQLWarning>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getWarnings";
            }

            @Override
            public SQLWarning execute(Statement t) throws SQLException {
                return t.getWarnings();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void clearWarnings() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.clearWarnings";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                t.clearWarnings();
                return null;
            }
        };
        this.executeTemplet(ec, 3);
    }

    @Override
    public void setCursorName(final String name) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setCursorName(name);
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public boolean execute(final String sql) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + sql + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(sql);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getResultSet()";
            }

            @Override
            public ResultSet execute(Statement t) throws SQLException {
                return t.getResultSet();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public int getUpdateCount() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getUpdateCount()";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getUpdateCount();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getMoreResults()";
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.getMoreResults();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setFetchDirection(final int direction) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setFetchDirection(direction);
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getFetchDirection();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public void setFetchSize(final int rows) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setFetchSize(rows);
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public int getFetchSize() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getFetchSize();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getResultSetConcurrency();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public int getResultSetType() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getResultSetType();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void addBatch(final String sql) throws SQLException {
        if (this.sqlType.equals("NULL") || !this.sqlType.equalsIgnoreCase("insert or delete or update") && !this.sqlType.equalsIgnoreCase("in transaction")) {
            this.getExecuteType(sql);
        }
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.addBatch(" + sql + ")";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                t.addBatch(sql);
                return null;
            }
        };
        this.executeTemplet(ec, 0);
    }

    @Override
    public void clearBatch() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.clearBatch();
                return null;
            }
        };
        this.executeTemplet(ec, 0);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        AbstractExecuteCommand<int[]> ec = new AbstractExecuteCommand<int[]>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeBatch()";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public int[] execute(Statement t) throws SQLException {
                return t.executeBatch();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dispatchConnection;
    }

    @Override
    public boolean getMoreResults(final int current) throws SQLException {
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getMoreResults()";
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.getMoreResults(current);
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getGeneratedKeys()";
            }

            @Override
            public ResultSet execute(Statement t) throws SQLException {
                return t.getGeneratedKeys();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public int executeUpdate(final String sql, final int autoGeneratedKeys) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + autoGeneratedKeys + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(sql, autoGeneratedKeys);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public int executeUpdate(final String sql, final int[] columnIndexes) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + columnIndexes + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(sql, columnIndexes);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public int executeUpdate(final String sql, final String[] columnNames) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + columnNames + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(sql, columnNames);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public boolean execute(final String sql, final int autoGeneratedKeys) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + autoGeneratedKeys + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(sql, autoGeneratedKeys);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public boolean execute(final String sql, final int[] columnIndexes) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + sql + "," + columnIndexes + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(sql, columnIndexes);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public boolean execute(final String sql, final String[] columnNames) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + sql + "," + columnNames + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(sql, columnNames);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getResultSetHoldability();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    protected boolean expectionHandler(SQLException e, Statement slave, Statement master) throws SQLException {
        boolean changeSuccess = false;
        if (this.getErrorCode(e)) {
            changeSuccess = true;
        }
        return changeSuccess;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.isClosed) {
            return true;
        }
        if (this.mainStatement != null && this.mainStatement.isClosed()) {
            this.isClosed = true;
            if (this.slaveStatement != null && !this.slaveStatement.isClosed()) {
                try {
                    this.slaveStatement.close();
                }
                catch (Exception exception) {}
            }
        } else if (this.slaveStatement != null && this.slaveStatement.isClosed()) {
            this.isClosed = true;
            if (this.mainStatement != null && !this.mainStatement.isClosed()) {
                try {
                    this.mainStatement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.isClosed;
    }

    @Override
    public void setPoolable(final boolean poolable) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setPoolable(poolable);
                DispatchStatementV2.this.poolable = poolable;
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                ((KbStatement)t).closeOnCompletion();
                DispatchStatementV2.this.closeOnCompletion = true;
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        AbstractExecuteCommand<Long> ec = new AbstractExecuteCommand<Long>(){

            @Override
            public Long execute(Statement t) throws SQLException {
                return t.getLargeUpdateCount();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setLargeMaxRows");
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getLargeMaxRows");
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        AbstractExecuteCommand<long[]> ec = new AbstractExecuteCommand<long[]>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeLargeUpdate()";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public long[] execute(Statement t) throws SQLException {
                return t.executeLargeBatch();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public long executeLargeUpdate(final String sql) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Long> ec = new AbstractExecuteCommand<Long>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeLargeUpdate(" + sql + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Long execute(Statement t) throws SQLException {
                return t.executeLargeUpdate(sql);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public long executeLargeUpdate(final String sql, final int autoGeneratedKeys) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Long> ec = new AbstractExecuteCommand<Long>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeLargeUpdate(" + sql + "," + autoGeneratedKeys + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Long execute(Statement t) throws SQLException {
                return t.executeLargeUpdate(sql, autoGeneratedKeys);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public long executeLargeUpdate(final String sql, final int[] columnIndexes) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Long> ec = new AbstractExecuteCommand<Long>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeLargeUpdate(" + sql + "," + columnIndexes + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Long execute(Statement t) throws SQLException {
                return t.executeLargeUpdate(sql, columnIndexes);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public long executeLargeUpdate(final String sql, final String[] columnNames) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Long> ec = new AbstractExecuteCommand<Long>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeLargeUpdate(" + sql + "," + columnNames + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Long execute(Statement t) throws SQLException {
                return t.executeLargeUpdate(sql, columnNames);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }
}

