/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core.v3;

import com.kingbase8.KBProperty;
import com.kingbase8.core.ConnectionFactory;
import com.kingbase8.core.Encoding;
import com.kingbase8.core.KBStream;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.ServerVersion;
import com.kingbase8.core.SetupQueryRunner;
import com.kingbase8.core.SocketFactoryFactory;
import com.kingbase8.core.Utils;
import com.kingbase8.core.Version;
import com.kingbase8.core.v3.QueryExecutorImpl;
import com.kingbase8.gss.MakeGSS;
import com.kingbase8.hostchooser.CandidateHost;
import com.kingbase8.hostchooser.GlobalHostStatusTracker;
import com.kingbase8.hostchooser.HostChooser;
import com.kingbase8.hostchooser.HostChooserFactory;
import com.kingbase8.hostchooser.HostRequirement;
import com.kingbase8.hostchooser.HostStatus;
import com.kingbase8.jdbc.SslMode;
import com.kingbase8.jre7.sasl.ScramAuthenticator;
import com.kingbase8.ssl.MakeSSL;
import com.kingbase8.sspi.ISSPIClient;
import com.kingbase8.util.GT;
import com.kingbase8.util.HostSpec;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import com.kingbase8.util.MD5Digest;
import com.kingbase8.util.ServerErrorMessage;
import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.net.SocketFactory;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    private static final int AUTH_REQ_GSS = 7;
    private static final int AUTH_REQ_GSS_CONTINUE = 8;
    private static final int AUTH_REQ_SSPI = 9;
    private static final int AUTH_REQ_SASL = 10;
    private static final int AUTH_REQ_SASL_CONTINUE = 11;
    private static final int AUTH_REQ_SASL_FINAL = 12;

    private ISSPIClient createSSPI(KBStream pgStream, String spnServiceClass, boolean enableNegotiate) {
        try {
            Class<?> c = Class.forName("com.kingbase8.sspi.SSPIClient");
            return (ISSPIClient)c.getDeclaredConstructor(KBStream.class, String.class, Boolean.TYPE).newInstance(pgStream, spnServiceClass, enableNegotiate);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load com.kingbase8.sspi.SSPIClient. Please check that SSPIClient is included in your kbjdbc distribution.", e);
        }
    }

    private KBStream tryConnect(String user, String database, Properties info, SocketFactory socketFactory, HostSpec hostSpec, SslMode sslMode, int version) throws SQLException, IOException {
        int sendBufferSize;
        int connectTimeout = KBProperty.CONNECT_TIMEOUT.getInt(info) * 1000;
        KBStream newStream = new KBStream(socketFactory, hostSpec, connectTimeout, KBProperty.USEDISPATCH.getBoolean(info), version);
        int socketTimeout = KBProperty.SOCKET_TIMEOUT.getInt(info);
        if (KBProperty.USEDISPATCH.getBoolean(info)) {
            if (socketTimeout < 0) {
                socketTimeout = 0;
            }
            newStream.getSocket().setSoTimeout(1000);
            newStream.setSocketTimeout(socketTimeout);
            LOGGER.log(Level.INFO, "socketTimeout is " + socketTimeout * 1000, new Object[0]);
        } else if (socketTimeout > 0) {
            newStream.getSocket().setSoTimeout(socketTimeout * 1000);
        }
        boolean requireTCPKeepAlive = KBProperty.TCP_KEEP_ALIVE.getBoolean(info);
        newStream.getSocket().setKeepAlive(requireTCPKeepAlive);
        int receiveBufferSize = KBProperty.RECEIVE_BUFFER_SIZE.getInt(info);
        if (receiveBufferSize > -1) {
            if (receiveBufferSize > 0) {
                newStream.getSocket().setReceiveBufferSize(receiveBufferSize);
            } else {
                LOGGER.log(Level.WARNING, "Ignore invalid value for receiveBufferSize: {0}", receiveBufferSize);
            }
        }
        if ((sendBufferSize = KBProperty.SEND_BUFFER_SIZE.getInt(info)) > -1) {
            if (sendBufferSize > 0) {
                newStream.getSocket().setSendBufferSize(sendBufferSize);
            } else {
                LOGGER.log(Level.WARNING, "Ignore invalid value for sendBufferSize: {0}", sendBufferSize);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Receive Buffer Size is {0}", newStream.getSocket().getReceiveBufferSize());
            LOGGER.log(Level.FINE, "Send Buffer Size is {0}", newStream.getSocket().getSendBufferSize());
        }
        newStream = this.enableSSL(newStream, sslMode, info, connectTimeout, version);
        List<String[]> paramList = this.getParametersForStartup(user, database, info);
        String client_encoding = KBProperty.CLIENT_ENCODING.get(info);
        newStream.setEncoding(Encoding.getJVMEncoding(client_encoding));
        this.sendStartupPacket(newStream, paramList, client_encoding);
        this.doAuthentication(newStream, hostSpec.getHost(), user, info);
        return newStream;
    }

    @Override
    public QueryExecutor openConnectionImpl(HostSpec[] hostSpecs, String user, String database, Properties info, int version) throws SQLException {
        HostRequirement targetServerType;
        SslMode sslMode = SslMode.of(info);
        String targetServerTypeStr = KBProperty.TARGET_SERVER_TYPE.get(info);
        try {
            targetServerType = HostRequirement.getTargetServerType(targetServerTypeStr);
        }
        catch (IllegalArgumentException ex) {
            throw new KSQLException(GT.tr("Invalid targetServerType value: {0}", targetServerTypeStr), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        SocketFactory socketFactory = SocketFactoryFactory.getSocketFactory(info);
        HostChooser hostChooser = HostChooserFactory.createHostChooser(hostSpecs, targetServerType, info);
        Iterator<CandidateHost> hostIter = hostChooser.iterator();
        HashMap<HostSpec, HostStatus> knownStates = new HashMap<HostSpec, HostStatus>();
        while (hostIter.hasNext()) {
            CandidateHost candidateHost = hostIter.next();
            HostSpec hostSpec = candidateHost.hostSpec;
            LOGGER.log(Level.FINE, "Trying to establish a protocol version 3 connection to {0}", hostSpec);
            HostStatus knownStatus = (HostStatus)((Object)knownStates.get(hostSpec));
            if (knownStatus != null && !candidateHost.targetServerType.allowConnectingTo(knownStatus)) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Known status of host {0} is {1}, and required status was {2}. Will try next host", new Object[]{hostSpec, knownStatus, candidateHost.targetServerType});
                continue;
            }
            KBStream newStream = null;
            try {
                try {
                    newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, sslMode, version);
                }
                catch (SQLException e) {
                    Exception ex;
                    if (sslMode == SslMode.PREFER && KSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(e.getSQLState())) {
                        ex = null;
                        try {
                            newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, SslMode.DISABLE, version);
                            LOGGER.log(Level.FINE, "Downgraded to non-encrypted connection for host {0}", hostSpec);
                        }
                        catch (SQLException ee) {
                            ex = ee;
                        }
                        catch (IOException ee) {
                            ex = ee;
                        }
                        if (ex != null) {
                            LOGGER.log(Level.FINE, "sslMode==PREFER, however non-SSL connection failed as well", ex);
                            e.addSuppressed(ex);
                            throw e;
                        }
                    }
                    if (sslMode == SslMode.ALLOW && KSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(e.getSQLState())) {
                        ex = null;
                        try {
                            newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, SslMode.REQUIRE, version);
                            LOGGER.log(Level.FINE, "Upgraded to encrypted connection for host {0}", hostSpec);
                        }
                        catch (SQLException ee) {
                            ex = ee;
                        }
                        catch (IOException ee) {
                            ex = ee;
                        }
                        if (ex != null) {
                            LOGGER.log(Level.FINE, "sslMode==ALLOW, however SSL connection failed as well", ex);
                            e.addSuppressed(ex);
                            throw e;
                        }
                    }
                    throw e;
                }
                int cancelSignalTimeout = KBProperty.CANCEL_SIGNAL_TIMEOUT.getInt(info) * 1000;
                QueryExecutorImpl queryExecutor = new QueryExecutorImpl(newStream, user, database, cancelSignalTimeout, info);
                HostStatus hostStatus = HostStatus.ConnectOK;
                if (candidateHost.targetServerType != HostRequirement.any) {
                    hostStatus = this.isMaster(queryExecutor) ? HostStatus.Master : HostStatus.Secondary;
                }
                GlobalHostStatusTracker.reportHostStatus(hostSpec, hostStatus);
                knownStates.put(hostSpec, hostStatus);
                if (!candidateHost.targetServerType.allowConnectingTo(hostStatus)) {
                    queryExecutor.close();
                    continue;
                }
                this.runInitialQueries(queryExecutor, info);
                return queryExecutor;
            }
            catch (ConnectException cex) {
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    LOGGER.log(Level.FINE, "ConnectException occurred while connecting to {0}", hostSpec);
                    LOGGER.log(Level.FINE, cex);
                    continue;
                }
                throw new KSQLException(GT.tr("Connection to {0} refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections.", hostSpec), KSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
            }
            catch (IOException ioe) {
                this.closeStream(newStream);
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    LOGGER.log(Level.FINE, "IOException occurred while connecting to {0}", hostSpec);
                    LOGGER.log(Level.FINE, ioe);
                    continue;
                }
                throw new KSQLException(GT.tr("The connection attempt failed.Reason:" + ioe.getMessage(), new Object[0]), KSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
            }
            catch (SQLException se) {
                this.closeStream(newStream);
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    LOGGER.log(Level.FINE, "SQLException occurred while connecting to {0}", hostSpec);
                    LOGGER.log(Level.FINE, se);
                    continue;
                }
                throw se;
            }
        }
        throw new KSQLException(GT.tr("Could not find a server with specified targetServerType: {0}", new Object[]{targetServerType}), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private List<String[]> getParametersForStartup(String user, String database, Properties info) {
        String options;
        String currentSchema;
        String client_encoding = KBProperty.CLIENT_ENCODING.get(info);
        if (client_encoding == null) {
            client_encoding = System.getProperty("file.encoding");
            KBProperty.CLIENT_ENCODING.set(info, client_encoding);
            LOGGER.log(Level.FINE, "Use current JVM default encoding {0}", client_encoding);
        }
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        paramList.add(new String[]{"user", user});
        paramList.add(new String[]{"database", database});
        paramList.add(new String[]{"client_encoding", client_encoding});
        paramList.add(new String[]{"DateStyle", "ISO"});
        paramList.add(new String[]{"TimeZone", ConnectionFactoryImpl.createPostgresTimeZone()});
        Version assumeVersion = ServerVersion.from(KBProperty.ASSUME_MIN_SERVER_VERSION.get(info));
        if (assumeVersion.getVersionNum() >= ServerVersion.v9_0.getVersionNum()) {
            paramList.add(new String[]{"extra_float_digits", "3"});
            String appName = KBProperty.APPLICATION_NAME.get(info);
            if (appName != null) {
                paramList.add(new String[]{"application_name", appName});
            }
        } else {
            paramList.add(new String[]{"extra_float_digits", "2"});
        }
        String replication = KBProperty.REPLICATION.get(info);
        if (replication != null && assumeVersion.getVersionNum() >= ServerVersion.v9_4.getVersionNum()) {
            paramList.add(new String[]{"replication", replication});
        }
        if ((currentSchema = KBProperty.CURRENT_SCHEMA.get(info)) != null) {
            paramList.add(new String[]{"search_path", currentSchema});
        }
        if ((options = KBProperty.OPTIONS.get(info)) != null) {
            paramList.add(new String[]{"options", options});
        }
        return paramList;
    }

    private static String createPostgresTimeZone() {
        String start;
        String tz = TimeZone.getDefault().getID();
        if (tz.length() <= 3 || !tz.startsWith("GMT")) {
            return tz;
        }
        char sign = tz.charAt(3);
        switch (sign) {
            case '+': {
                start = "GMT-";
                break;
            }
            case '-': {
                start = "GMT+";
                break;
            }
            default: {
                return tz;
            }
        }
        return start + tz.substring(4);
    }

    private KBStream enableSSL(KBStream pgStream, SslMode sslMode, Properties info, int connectTimeout, int version) throws IOException, KSQLException {
        if (sslMode == SslMode.DISABLE) {
            return pgStream;
        }
        if (sslMode == SslMode.ALLOW) {
            return pgStream;
        }
        LOGGER.log(Level.FINEST, " FE=> SSLRequest", new Object[0]);
        pgStream.sendInteger4(8);
        pgStream.sendInteger2(1234);
        pgStream.sendInteger2(5679);
        pgStream.flush();
        int beresp = pgStream.receiveChar();
        switch (beresp) {
            case 69: {
                LOGGER.log(Level.FINEST, " <=BE SSLError", new Object[0]);
                if (sslMode.requireEncryption()) {
                    throw new KSQLException(GT.tr("The server does not support SSL.", new Object[0]), KSQLState.CONNECTION_REJECTED);
                }
                pgStream.close();
                return new KBStream(pgStream.getSocketFactory(), pgStream.getHostSpec(), connectTimeout, KBProperty.USEDISPATCH.getBoolean(info), version);
            }
            case 78: {
                LOGGER.log(Level.FINEST, " <=BE SSLRefused", new Object[0]);
                if (sslMode.requireEncryption()) {
                    throw new KSQLException(GT.tr("The server does not support SSL.", new Object[0]), KSQLState.CONNECTION_REJECTED);
                }
                return pgStream;
            }
            case 83: {
                LOGGER.log(Level.FINEST, " <=BE SSLOk", new Object[0]);
                MakeSSL.convert(pgStream, info);
                return pgStream;
            }
        }
        throw new KSQLException(GT.tr("An error occurred while setting up the SSL connection.", new Object[0]), KSQLState.PROTOCOL_VIOLATION);
    }

    private void sendStartupPacket(KBStream pgStream, List<String[]> params, String encoding) throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder details = new StringBuilder();
            for (int i = 0; i < params.size(); ++i) {
                if (i != 0) {
                    details.append(", ");
                }
                details.append(params.get(i)[0]);
                details.append("=");
                details.append(params.get(i)[1]);
            }
            LOGGER.log(Level.FINEST, " FE=> StartupPacket({0})", details);
        }
        int length = 8;
        byte[][] encodedParams = new byte[params.size() * 2][];
        for (int i = 0; i < params.size(); ++i) {
            encodedParams[i * 2] = params.get(i)[0].getBytes(encoding);
            encodedParams[i * 2 + 1] = params.get(i)[1].getBytes(encoding);
            length += encodedParams[i * 2].length + 1 + encodedParams[i * 2 + 1].length + 1;
        }
        pgStream.sendInteger4(++length);
        pgStream.sendInteger2(3);
        pgStream.sendInteger2(0);
        for (byte[] encodedParam : encodedParams) {
            pgStream.send(encodedParam);
            pgStream.sendChar(0);
        }
        pgStream.sendChar(0);
        pgStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doAuthentication(KBStream pgStream, String host, String user, Properties info) throws IOException, SQLException {
        String password = KBProperty.PASSWORD.get(info);
        String client_encoding = KBProperty.CLIENT_ENCODING.get(info);
        ISSPIClient sspiClient = null;
        ScramAuthenticator scramAuthenticator = null;
        try {
            block20: while (true) {
                int beresp = pgStream.receiveChar();
                block3 : switch (beresp) {
                    case 69: {
                        int elen = pgStream.receiveInteger4();
                        ServerErrorMessage errorMsg = new ServerErrorMessage(pgStream.receiveErrorString(elen - 4));
                        LOGGER.log(Level.FINEST, " <=BE ErrorMessage({0})", errorMsg);
                        throw new KSQLException(errorMsg, KBProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                    }
                    case 82: {
                        int msgLen = pgStream.receiveInteger4();
                        int areq = pgStream.receiveInteger4();
                        switch (areq) {
                            case 5: {
                                byte[] md5Salt = pgStream.receive(4);
                                if (LOGGER.isLoggable(Level.FINEST)) {
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationReqMD5(salt={0})", Utils.toHexString(md5Salt));
                                }
                                if (password == null) {
                                    throw new KSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), KSQLState.CONNECTION_REJECTED);
                                }
                                byte[] digest = MD5Digest.encode(user.getBytes(client_encoding), password.getBytes(client_encoding), md5Salt);
                                if (LOGGER.isLoggable(Level.FINEST)) {
                                    LOGGER.log(Level.FINEST, " FE=> Password(md5digest={0})", new String(digest, "US-ASCII"));
                                }
                                pgStream.sendChar(112);
                                pgStream.sendInteger4(4 + digest.length + 1);
                                pgStream.send(digest);
                                pgStream.sendChar(0);
                                pgStream.flush();
                                break block3;
                            }
                            case 3: {
                                LOGGER.log(Level.FINEST, "<=BE AuthenticationReqPassword", new Object[0]);
                                LOGGER.log(Level.FINEST, " FE=> Password(password=<not shown>)", new Object[0]);
                                if (password == null) {
                                    throw new KSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), KSQLState.CONNECTION_REJECTED);
                                }
                                byte[] encodedPassword = password.getBytes(client_encoding);
                                pgStream.sendChar(112);
                                pgStream.sendInteger4(4 + encodedPassword.length + 1);
                                pgStream.send(encodedPassword);
                                pgStream.sendChar(0);
                                pgStream.flush();
                                break block3;
                            }
                            case 7: 
                            case 9: {
                                String gsslib = KBProperty.GSS_LIB.get(info);
                                boolean usespnego = KBProperty.USE_SPNEGO.getBoolean(info);
                                boolean useSSPI = false;
                                if (gsslib.equals("gssapi")) {
                                    LOGGER.log(Level.FINE, "Using JSSE GSSAPI, param gsslib=gssapi", new Object[0]);
                                } else if (areq == 7 && !gsslib.equals("sspi")) {
                                    LOGGER.log(Level.FINE, "Using JSSE GSSAPI, gssapi requested by server and gsslib=sspi not forced", new Object[0]);
                                } else {
                                    sspiClient = this.createSSPI(pgStream, KBProperty.SSPI_SERVICE_CLASS.get(info), areq == 9 || areq == 7 && usespnego);
                                    useSSPI = sspiClient.isSSPISupported();
                                    LOGGER.log(Level.FINE, "SSPI support detected: {0}", useSSPI);
                                    if (!useSSPI) {
                                        sspiClient = null;
                                        if (gsslib.equals("sspi")) {
                                            throw new KSQLException("SSPI forced with gsslib=sspi, but SSPI not available; set loglevel=2 for details", KSQLState.CONNECTION_UNABLE_TO_CONNECT);
                                        }
                                    }
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.log(Level.FINE, "Using SSPI: {0}, gsslib={1} and SSPI support detected", useSSPI, gsslib);
                                    }
                                }
                                if (useSSPI) {
                                    sspiClient.startSSPI();
                                    break block3;
                                }
                                MakeGSS.authenticate(pgStream, host, user, password, KBProperty.JAAS_APPLICATION_NAME.get(info), KBProperty.KERBEROS_SERVER_NAME.get(info), usespnego, KBProperty.JAAS_LOGIN.getBoolean(info), KBProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                                break block3;
                            }
                            case 8: {
                                sspiClient.continueSSPI(msgLen - 8);
                                break block3;
                            }
                            case 10: {
                                LOGGER.log(Level.FINEST, " <=BE AuthenticationSASL", new Object[0]);
                                scramAuthenticator = new ScramAuthenticator(user, password, pgStream);
                                scramAuthenticator.processServerMechanismsAndInit();
                                scramAuthenticator.sendScramClientFirstMessage();
                                break block3;
                            }
                            case 11: {
                                scramAuthenticator.processServerFirstMessage(msgLen - 4 - 4);
                                break block3;
                            }
                            case 12: {
                                scramAuthenticator.verifyServerSignature(msgLen - 4 - 4);
                                break block3;
                            }
                            case 0: {
                                LOGGER.log(Level.FINEST, " <=BE AuthenticationOk", new Object[0]);
                                break block20;
                            }
                            default: {
                                LOGGER.log(Level.FINEST, " <=BE AuthenticationReq (unsupported type {0})", areq);
                                throw new KSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", areq), KSQLState.CONNECTION_REJECTED);
                            }
                        }
                    }
                    default: {
                        throw new KSQLException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), KSQLState.PROTOCOL_VIOLATION);
                    }
                }
            }
            if (sspiClient == null) return;
        }
        catch (Throwable throwable) {
            if (sspiClient == null) throw throwable;
            try {
                sspiClient.dispose();
                throw throwable;
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.FINE, "Unexpected error during SSPI context disposal", ex);
            }
            throw throwable;
        }
        try {
            sspiClient.dispose();
            return;
        }
        catch (RuntimeException ex) {
            LOGGER.log(Level.FINE, "Unexpected error during SSPI context disposal", ex);
        }
    }

    private void runInitialQueries(QueryExecutor queryExecutor, Properties info) throws SQLException {
        String appName;
        String assumeMinServerVersion;
        String initParams = KBProperty.INIT_PARAMS.get(info);
        if (initParams != null) {
            String[] params;
            for (String param : params = initParams.split(";")) {
                try {
                    SetupQueryRunner.run(queryExecutor, "SET " + param, false);
                }
                catch (Exception e) {
                    System.err.println(param + " is invalid");
                }
            }
        }
        if (Utils.parseServerVersionStr(assumeMinServerVersion = KBProperty.ASSUME_MIN_SERVER_VERSION.get(info)) >= ServerVersion.v9_0.getVersionNum()) {
            return;
        }
        int dbVersion = queryExecutor.getServerVersionNum();
        if (dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            SetupQueryRunner.run(queryExecutor, "SET extra_float_digits = 3", false);
        }
        if ((appName = KBProperty.APPLICATION_NAME.get(info)) != null && dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            StringBuilder sql = new StringBuilder();
            sql.append("SET application_name = '");
            Utils.escapeLiteral(sql, appName, queryExecutor.getStandardConformingStrings());
            sql.append("'");
            SetupQueryRunner.run(queryExecutor, sql.toString(), false);
        }
    }

    private boolean isMaster(QueryExecutor queryExecutor) throws SQLException, IOException {
        byte[][] results = SetupQueryRunner.run(queryExecutor, "show transaction_read_only", true);
        String value = queryExecutor.getEncoding().decode(results[0]);
        return value.equalsIgnoreCase("off");
    }
}

