/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import java.util.logging.Level;

class BooleanTypeUtil {
    private BooleanTypeUtil() {
    }

    static boolean castToBoolean(Object in) throws KSQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Cast to boolean: \"{0}\"", String.valueOf(in));
        }
        if (in instanceof Boolean) {
            return (Boolean)in;
        }
        if (in instanceof String) {
            return BooleanTypeUtil.fromString((String)in);
        }
        if (in instanceof Character) {
            return BooleanTypeUtil.fromCharacter((Character)in);
        }
        if (in instanceof Number) {
            return BooleanTypeUtil.fromNumber((Number)in);
        }
        throw new KSQLException("Cannot cast to boolean", KSQLState.CANNOT_COERCE);
    }

    private static boolean fromString(String strval) throws KSQLException {
        String val = strval.trim();
        if ("1".equals(val) || "true".equalsIgnoreCase(val) || "t".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val) || "y".equalsIgnoreCase(val) || "on".equalsIgnoreCase(val)) {
            return true;
        }
        if ("0".equals(val) || "false".equalsIgnoreCase(val) || "f".equalsIgnoreCase(val) || "no".equalsIgnoreCase(val) || "n".equalsIgnoreCase(val) || "off".equalsIgnoreCase(val)) {
            return false;
        }
        if ("oracle".equals(KbConnection.compatibleLevel)) {
            double a = 0.0;
            try {
                a = Double.parseDouble(strval);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (a != 0.0) {
                return true;
            }
        }
        throw BooleanTypeUtil.cannotCoerceException(strval);
    }

    private static boolean fromCharacter(Character charval) throws KSQLException {
        if ('1' == charval.charValue() || 't' == charval.charValue() || 'T' == charval.charValue() || 'y' == charval.charValue() || 'Y' == charval.charValue()) {
            return true;
        }
        if ('0' == charval.charValue() || 'f' == charval.charValue() || 'F' == charval.charValue() || 'n' == charval.charValue() || 'N' == charval.charValue()) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException(charval);
    }

    private static boolean fromNumber(Number numval) throws KSQLException {
        double value = numval.doubleValue();
        if (value == 1.0) {
            return true;
        }
        if (value == 0.0) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException(numval);
    }

    private static KSQLException cannotCoerceException(Object value) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Cannot cast to boolean: \"{0}\"", String.valueOf(value));
        }
        return new KSQLException(GT.tr("Cannot cast to boolean: \"{0}\"", String.valueOf(value)), KSQLState.CANNOT_COERCE);
    }
}

