/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jre7.sasl;

import com.kingbase8.core.KBStream;
import com.kingbase8.shaded.com.ongres.scram.client.ScramClient;
import com.kingbase8.shaded.com.ongres.scram.client.ScramSession;
import com.kingbase8.shaded.com.ongres.scram.common.exception.ScramException;
import com.kingbase8.shaded.com.ongres.scram.common.exception.ScramInvalidServerSignatureException;
import com.kingbase8.shaded.com.ongres.scram.common.exception.ScramParseException;
import com.kingbase8.shaded.com.ongres.scram.common.exception.ScramServerErrorException;
import com.kingbase8.shaded.com.ongres.scram.common.stringprep.StringPreparations;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;

public class ScramAuthenticator {
    private final String user;
    private final String password;
    private final KBStream pgStream;
    private ScramClient scramClient;
    private ScramSession scramSession;
    private ScramSession.ServerFirstProcessor serverFirstProcessor;
    private ScramSession.ClientFinalProcessor clientFinalProcessor;

    private void sendAuthenticationMessage(int bodyLength, BodySender bodySender) throws IOException {
        this.pgStream.sendChar(112);
        this.pgStream.sendInteger4(4 + bodyLength);
        bodySender.sendBody(this.pgStream);
        this.pgStream.flush();
    }

    public ScramAuthenticator(String user, String password, KBStream pgStream) {
        this.user = user;
        this.password = password;
        this.pgStream = pgStream;
    }

    public void processServerMechanismsAndInit() throws IOException, KSQLException {
        ArrayList<String> mechanisms = new ArrayList<String>();
        do {
            mechanisms.add(this.pgStream.receiveString());
        } while (this.pgStream.peekChar() != 0);
        int c = this.pgStream.receiveChar();
        assert (c == 0);
        if (mechanisms.size() < 1) {
            throw new KSQLException(GT.tr("No SCRAM mechanism(s) advertised by the server", new Object[0]), KSQLState.CONNECTION_REJECTED);
        }
        try {
            this.scramClient = ScramClient.channelBinding(ScramClient.ChannelBinding.NO).stringPreparation(StringPreparations.NO_PREPARATION).selectMechanismBasedOnServerAdvertised(mechanisms.toArray(new String[0])).setup();
        }
        catch (IllegalArgumentException e) {
            throw new KSQLException(GT.tr("Invalid or unsupported by client SCRAM mechanisms", e), KSQLState.CONNECTION_REJECTED);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " Using SCRAM mechanism {0}", this.scramClient.getScramMechanism().getName());
        }
        this.scramSession = this.scramClient.scramSession("*");
    }

    public void sendScramClientFirstMessage() throws IOException {
        String clientFirstMessage = this.scramSession.clientFirstMessage();
        LOGGER.log(Level.FINEST, " FE=> SASLInitialResponse( {0} )", clientFirstMessage);
        String scramMechanismName = this.scramClient.getScramMechanism().getName();
        final byte[] scramMechanismNameBytes = scramMechanismName.getBytes(StandardCharsets.UTF_8);
        final byte[] clientFirstMessageBytes = clientFirstMessage.getBytes(StandardCharsets.UTF_8);
        this.sendAuthenticationMessage(scramMechanismNameBytes.length + 1 + 4 + clientFirstMessageBytes.length, new BodySender(){

            @Override
            public void sendBody(KBStream pgStream) throws IOException {
                pgStream.send(scramMechanismNameBytes);
                pgStream.sendChar(0);
                pgStream.sendInteger4(clientFirstMessageBytes.length);
                pgStream.send(clientFirstMessageBytes);
            }
        });
    }

    public void processServerFirstMessage(int length) throws IOException, KSQLException {
        String serverFirstMessage = this.pgStream.receiveString(length);
        LOGGER.log(Level.FINEST, " <=BE AuthenticationSASLContinue( {0} )", serverFirstMessage);
        try {
            this.serverFirstProcessor = this.scramSession.receiveServerFirstMessage(serverFirstMessage);
        }
        catch (ScramException e) {
            throw new KSQLException(GT.tr("Invalid server-first-message: {0}", serverFirstMessage), KSQLState.CONNECTION_REJECTED, (Throwable)e);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " <=BE AuthenticationSASLContinue(salt={0}, iterations={1})", this.serverFirstProcessor.getSalt(), this.serverFirstProcessor.getIteration());
        }
        this.clientFinalProcessor = this.serverFirstProcessor.clientFinalProcessor(this.password);
        String clientFinalMessage = this.clientFinalProcessor.clientFinalMessage();
        LOGGER.log(Level.FINEST, " FE=> SASLResponse( {0} )", clientFinalMessage);
        final byte[] clientFinalMessageBytes = clientFinalMessage.getBytes(StandardCharsets.UTF_8);
        this.sendAuthenticationMessage(clientFinalMessageBytes.length, new BodySender(){

            @Override
            public void sendBody(KBStream pgStream) throws IOException {
                pgStream.send(clientFinalMessageBytes);
            }
        });
    }

    public void verifyServerSignature(int length) throws IOException, KSQLException {
        String serverFinalMessage = this.pgStream.receiveString(length);
        LOGGER.log(Level.FINEST, " <=BE AuthenticationSASLFinal( {0} )", serverFinalMessage);
        try {
            this.clientFinalProcessor.receiveServerFinalMessage(serverFinalMessage);
        }
        catch (ScramParseException e) {
            throw new KSQLException(GT.tr("Invalid server-final-message: {0}", serverFinalMessage), KSQLState.CONNECTION_REJECTED, (Throwable)e);
        }
        catch (ScramServerErrorException e) {
            throw new KSQLException(GT.tr("SCRAM authentication failed, server returned error: {0}", e.getError().getErrorMessage()), KSQLState.CONNECTION_REJECTED, (Throwable)e);
        }
        catch (ScramInvalidServerSignatureException e) {
            throw new KSQLException(GT.tr("Invalid server SCRAM signature", new Object[0]), KSQLState.CONNECTION_REJECTED, (Throwable)e);
        }
    }

    private static interface BodySender {
        public void sendBody(KBStream var1) throws IOException;
    }
}

